/* CodeMirror, copyright (c) by Marijn Haverbeke and others. Distributed under an MIT license: http://codemirror.net/LICENSE */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define(factory):global.CodeMirror=factory()}(this,function(){"use strict";function classTest(cls){return new RegExp("(^|\\s)"+cls+"(?:$|\\s)\\s*")}function removeChildren(e){for(var count=e.childNodes.length;count>0;--count)e.removeChild(e.firstChild);return e}function removeChildrenAndAdd(parent,e){return removeChildren(parent).appendChild(e)}function elt(tag,content,className,style){var e=document.createElement(tag);if(className&&(e.className=className),style&&(e.style.cssText=style),"string"==typeof content)e.appendChild(document.createTextNode(content));else if(content)for(var i=0;i<content.length;++i)e.appendChild(content[i]);return e}function eltP(tag,content,className,style){var e=elt(tag,content,className,style);return e.setAttribute("role","presentation"),e}function contains(parent,child){if(3==child.nodeType&&(child=child.parentNode),parent.contains)return parent.contains(child);do if(11==child.nodeType&&(child=child.host),child==parent)return!0;while(child=child.parentNode)}function activeElt(){var activeElement;try{activeElement=document.activeElement}catch(e){activeElement=document.body||null}for(;activeElement&&activeElement.shadowRoot&&activeElement.shadowRoot.activeElement;)activeElement=activeElement.shadowRoot.activeElement;return activeElement}function addClass(node,cls){var current=node.className;classTest(cls).test(current)||(node.className+=(current?" ":"")+cls)}function joinClasses(a,b){for(var as=a.split(" "),i=0;i<as.length;i++)as[i]&&!classTest(as[i]).test(b)&&(b+=" "+as[i]);return b}function bind(f){var args=Array.prototype.slice.call(arguments,1);return function(){return f.apply(null,args)}}function copyObj(obj,target,overwrite){target||(target={});for(var prop in obj)!obj.hasOwnProperty(prop)||overwrite===!1&&target.hasOwnProperty(prop)||(target[prop]=obj[prop]);return target}function countColumn(string,end,tabSize,startIndex,startValue){null==end&&(end=string.search(/[^\s\u00a0]/),end==-1&&(end=string.length));for(var i=startIndex||0,n=startValue||0;;){var nextTab=string.indexOf("\t",i);if(nextTab<0||nextTab>=end)return n+(end-i);n+=nextTab-i,n+=tabSize-n%tabSize,i=nextTab+1}}function indexOf(array,elt){for(var i=0;i<array.length;++i)if(array[i]==elt)return i;return-1}function findColumn(string,goal,tabSize){for(var pos=0,col=0;;){var nextTab=string.indexOf("\t",pos);nextTab==-1&&(nextTab=string.length);var skipped=nextTab-pos;if(nextTab==string.length||col+skipped>=goal)return pos+Math.min(skipped,goal-col);if(col+=nextTab-pos,col+=tabSize-col%tabSize,pos=nextTab+1,col>=goal)return pos}}function spaceStr(n){for(;spaceStrs.length<=n;)spaceStrs.push(lst(spaceStrs)+" ");return spaceStrs[n]}function lst(arr){return arr[arr.length-1]}function map(array,f){for(var out=[],i=0;i<array.length;i++)out[i]=f(array[i],i);return out}function insertSorted(array,value,score){for(var pos=0,priority=score(value);pos<array.length&&score(array[pos])<=priority;)pos++;array.splice(pos,0,value)}function nothing(){}function createObj(base,props){var inst;return Object.create?inst=Object.create(base):(nothing.prototype=base,inst=new nothing),props&&copyObj(props,inst),inst}function isWordCharBasic(ch){return/\w/.test(ch)||ch>"\x80"&&(ch.toUpperCase()!=ch.toLowerCase()||nonASCIISingleCaseWordChar.test(ch))}function isWordChar(ch,helper){return helper?!!(helper.source.indexOf("\\w")>-1&&isWordCharBasic(ch))||helper.test(ch):isWordCharBasic(ch)}function isEmpty(obj){for(var n in obj)if(obj.hasOwnProperty(n)&&obj[n])return!1;return!0}function isExtendingChar(ch){return ch.charCodeAt(0)>=768&&extendingChars.test(ch)}function skipExtendingChars(str,pos,dir){for(;(dir<0?pos>0:pos<str.length)&&isExtendingChar(str.charAt(pos));)pos+=dir;return pos}function findFirst(pred,from,to){for(var dir=from>to?-1:1;;){if(from==to)return from;var midF=(from+to)/2,mid=dir<0?Math.ceil(midF):Math.floor(midF);if(mid==from)return pred(mid)?from:to;pred(mid)?to=mid:from=mid+dir}}function iterateBidiSections(order,from,to,f){if(!order)return f(from,to,"ltr",0);for(var found=!1,i=0;i<order.length;++i){var part=order[i];(part.from<to&&part.to>from||from==to&&part.to==from)&&(f(Math.max(part.from,from),Math.min(part.to,to),1==part.level?"rtl":"ltr",i),found=!0)}found||f(from,to,"ltr")}function getBidiPartAt(order,ch,sticky){var found;bidiOther=null;for(var i=0;i<order.length;++i){var cur=order[i];if(cur.from<ch&&cur.to>ch)return i;cur.to==ch&&(cur.from!=cur.to&&"before"==sticky?found=i:bidiOther=i),cur.from==ch&&(cur.from!=cur.to&&"before"!=sticky?found=i:bidiOther=i)}return null!=found?found:bidiOther}function getOrder(line,direction){var order=line.order;return null==order&&(order=line.order=bidiOrdering(line.text,direction)),order}function getHandlers(emitter,type){return emitter._handlers&&emitter._handlers[type]||noHandlers}function off(emitter,type,f){if(emitter.removeEventListener)emitter.removeEventListener(type,f,!1);else if(emitter.detachEvent)emitter.detachEvent("on"+type,f);else{var map$$1=emitter._handlers,arr=map$$1&&map$$1[type];if(arr){var index=indexOf(arr,f);index>-1&&(map$$1[type]=arr.slice(0,index).concat(arr.slice(index+1)))}}}function signal(emitter,type){var handlers=getHandlers(emitter,type);if(handlers.length)for(var args=Array.prototype.slice.call(arguments,2),i=0;i<handlers.length;++i)handlers[i].apply(null,args)}function signalDOMEvent(cm,e,override){return"string"==typeof e&&(e={type:e,preventDefault:function(){this.defaultPrevented=!0}}),signal(cm,override||e.type,cm,e),e_defaultPrevented(e)||e.codemirrorIgnore}function signalCursorActivity(cm){var arr=cm._handlers&&cm._handlers.cursorActivity;if(arr)for(var set=cm.curOp.cursorActivityHandlers||(cm.curOp.cursorActivityHandlers=[]),i=0;i<arr.length;++i)indexOf(set,arr[i])==-1&&set.push(arr[i])}function hasHandler(emitter,type){return getHandlers(emitter,type).length>0}function eventMixin(ctor){ctor.prototype.on=function(type,f){on(this,type,f)},ctor.prototype.off=function(type,f){off(this,type,f)}}function e_preventDefault(e){e.preventDefault?e.preventDefault():e.returnValue=!1}function e_stopPropagation(e){e.stopPropagation?e.stopPropagation():e.cancelBubble=!0}function e_defaultPrevented(e){return null!=e.defaultPrevented?e.defaultPrevented:0==e.returnValue}function e_stop(e){e_preventDefault(e),e_stopPropagation(e)}function e_target(e){return e.target||e.srcElement}function e_button(e){var b=e.which;return null==b&&(1&e.button?b=1:2&e.button?b=3:4&e.button&&(b=2)),mac&&e.ctrlKey&&1==b&&(b=3),b}function zeroWidthElement(measure){if(null==zwspSupported){var test=elt("span","\u200b");removeChildrenAndAdd(measure,elt("span",[test,document.createTextNode("x")])),0!=measure.firstChild.offsetHeight&&(zwspSupported=test.offsetWidth<=1&&test.offsetHeight>2&&!(ie&&ie_version<8))}var node=zwspSupported?elt("span","\u200b"):elt("span","\xa0",null,"display: inline-block; width: 1px; margin-right: -1px");return node.setAttribute("cm-text",""),node}function hasBadBidiRects(measure){if(null!=badBidiRects)return badBidiRects;var txt=removeChildrenAndAdd(measure,document.createTextNode("A\u062eA")),r0=range(txt,0,1).getBoundingClientRect(),r1=range(txt,1,2).getBoundingClientRect();return removeChildren(measure),!(!r0||r0.left==r0.right)&&(badBidiRects=r1.right-r0.right<3)}function hasBadZoomedRects(measure){if(null!=badZoomedRects)return badZoomedRects;var node=removeChildrenAndAdd(measure,elt("span","x")),normal=node.getBoundingClientRect(),fromRange=range(node,0,1).getBoundingClientRect();return badZoomedRects=Math.abs(normal.left-fromRange.left)>1}function defineMode(name,mode){arguments.length>2&&(mode.dependencies=Array.prototype.slice.call(arguments,2)),modes[name]=mode}function defineMIME(mime,spec){mimeModes[mime]=spec}function resolveMode(spec){if("string"==typeof spec&&mimeModes.hasOwnProperty(spec))spec=mimeModes[spec];else if(spec&&"string"==typeof spec.name&&mimeModes.hasOwnProperty(spec.name)){var found=mimeModes[spec.name];"string"==typeof found&&(found={name:found}),spec=createObj(found,spec),spec.name=found.name}else{if("string"==typeof spec&&/^[\w\-]+\/[\w\-]+\+xml$/.test(spec))return resolveMode("application/xml");if("string"==typeof spec&&/^[\w\-]+\/[\w\-]+\+json$/.test(spec))return resolveMode("application/json")}return"string"==typeof spec?{name:spec}:spec||{name:"null"}}function getMode(options,spec){spec=resolveMode(spec);var mfactory=modes[spec.name];if(!mfactory)return getMode(options,"text/plain");var modeObj=mfactory(options,spec);if(modeExtensions.hasOwnProperty(spec.name)){var exts=modeExtensions[spec.name];for(var prop in exts)exts.hasOwnProperty(prop)&&(modeObj.hasOwnProperty(prop)&&(modeObj["_"+prop]=modeObj[prop]),modeObj[prop]=exts[prop])}if(modeObj.name=spec.name,spec.helperType&&(modeObj.helperType=spec.helperType),spec.modeProps)for(var prop$1 in spec.modeProps)modeObj[prop$1]=spec.modeProps[prop$1];return modeObj}function extendMode(mode,properties){var exts=modeExtensions.hasOwnProperty(mode)?modeExtensions[mode]:modeExtensions[mode]={};copyObj(properties,exts)}function copyState(mode,state){if(state===!0)return state;if(mode.copyState)return mode.copyState(state);var nstate={};for(var n in state){var val=state[n];val instanceof Array&&(val=val.concat([])),nstate[n]=val}return nstate}function innerMode(mode,state){for(var info;mode.innerMode&&(info=mode.innerMode(state),info&&info.mode!=mode);)state=info.state,mode=info.mode;return info||{mode:mode,state:state}}function startState(mode,a1,a2){return!mode.startState||mode.startState(a1,a2)}function getLine(doc,n){if(n-=doc.first,n<0||n>=doc.size)throw new Error("There is no line "+(n+doc.first)+" in the document.");for(var chunk=doc;!chunk.lines;)for(var i=0;;++i){var child=chunk.children[i],sz=child.chunkSize();if(n<sz){chunk=child;break}n-=sz}return chunk.lines[n]}function getBetween(doc,start,end){var out=[],n=start.line;return doc.iter(start.line,end.line+1,function(line){var text=line.text;n==end.line&&(text=text.slice(0,end.ch)),n==start.line&&(text=text.slice(start.ch)),out.push(text),++n}),out}function getLines(doc,from,to){var out=[];return doc.iter(from,to,function(line){out.push(line.text)}),out}function updateLineHeight(line,height){var diff=height-line.height;if(diff)for(var n=line;n;n=n.parent)n.height+=diff}function lineNo(line){if(null==line.parent)return null;for(var cur=line.parent,no=indexOf(cur.lines,line),chunk=cur.parent;chunk;cur=chunk,chunk=chunk.parent)for(var i=0;chunk.children[i]!=cur;++i)no+=chunk.children[i].chunkSize();return no+cur.first}function lineAtHeight(chunk,h){var n=chunk.first;outer:do{for(var i$1=0;i$1<chunk.children.length;++i$1){var child=chunk.children[i$1],ch=child.height;if(h<ch){chunk=child;continue outer}h-=ch,n+=child.chunkSize()}return n}while(!chunk.lines);for(var i=0;i<chunk.lines.length;++i){var line=chunk.lines[i],lh=line.height;if(h<lh)break;h-=lh}return n+i}function isLine(doc,l){return l>=doc.first&&l<doc.first+doc.size}function lineNumberFor(options,i){return String(options.lineNumberFormatter(i+options.firstLineNumber))}function Pos(line,ch,sticky){return void 0===sticky&&(sticky=null),this instanceof Pos?(this.line=line,this.ch=ch,void(this.sticky=sticky)):new Pos(line,ch,sticky)}function cmp(a,b){return a.line-b.line||a.ch-b.ch}function equalCursorPos(a,b){return a.sticky==b.sticky&&0==cmp(a,b)}function copyPos(x){return Pos(x.line,x.ch)}function maxPos(a,b){return cmp(a,b)<0?b:a}function minPos(a,b){return cmp(a,b)<0?a:b}function clipLine(doc,n){return Math.max(doc.first,Math.min(n,doc.first+doc.size-1))}function clipPos(doc,pos){if(pos.line<doc.first)return Pos(doc.first,0);var last=doc.first+doc.size-1;return pos.line>last?Pos(last,getLine(doc,last).text.length):clipToLen(pos,getLine(doc,pos.line).text.length)}function clipToLen(pos,linelen){var ch=pos.ch;return null==ch||ch>linelen?Pos(pos.line,linelen):ch<0?Pos(pos.line,0):pos}function clipPosArray(doc,array){for(var out=[],i=0;i<array.length;i++)out[i]=clipPos(doc,array[i]);return out}function highlightLine(cm,line,context,forceToEnd){var st=[cm.state.modeGen],lineClasses={};runMode(cm,line.text,cm.doc.mode,context,function(end,style){return st.push(end,style)},lineClasses,forceToEnd);for(var state=context.state,loop=function(o){context.baseTokens=st;var overlay=cm.state.overlays[o],i=1,at=0;context.state=!0,runMode(cm,line.text,overlay.mode,context,function(end,style){for(var start=i;at<end;){var i_end=st[i];i_end>end&&st.splice(i,1,end,st[i+1],i_end),i+=2,at=Math.min(end,i_end)}if(style)if(overlay.opaque)st.splice(start,i-start,end,"overlay "+style),i=start+2;else for(;start<i;start+=2){var cur=st[start+1];st[start+1]=(cur?cur+" ":"")+"overlay "+style}},lineClasses),context.state=state,context.baseTokens=null,context.baseTokenPos=1},o=0;o<cm.state.overlays.length;++o)loop(o);return{styles:st,classes:lineClasses.bgClass||lineClasses.textClass?lineClasses:null}}function getLineStyles(cm,line,updateFrontier){if(!line.styles||line.styles[0]!=cm.state.modeGen){var context=getContextBefore(cm,lineNo(line)),resetState=line.text.length>cm.options.maxHighlightLength&&copyState(cm.doc.mode,context.state),result=highlightLine(cm,line,context);resetState&&(context.state=resetState),line.stateAfter=context.save(!resetState),line.styles=result.styles,result.classes?line.styleClasses=result.classes:line.styleClasses&&(line.styleClasses=null),updateFrontier===cm.doc.highlightFrontier&&(cm.doc.modeFrontier=Math.max(cm.doc.modeFrontier,++cm.doc.highlightFrontier))}return line.styles}function getContextBefore(cm,n,precise){var doc=cm.doc,display=cm.display;if(!doc.mode.startState)return new Context(doc,!0,n);var start=findStartLine(cm,n,precise),saved=start>doc.first&&getLine(doc,start-1).stateAfter,context=saved?Context.fromSaved(doc,saved,start):new Context(doc,startState(doc.mode),start);return doc.iter(start,n,function(line){processLine(cm,line.text,context);var pos=context.line;line.stateAfter=pos==n-1||pos%5==0||pos>=display.viewFrom&&pos<display.viewTo?context.save():null,context.nextLine()}),precise&&(doc.modeFrontier=context.line),context}function processLine(cm,text,context,startAt){var mode=cm.doc.mode,stream=new StringStream(text,cm.options.tabSize,context);for(stream.start=stream.pos=startAt||0,""==text&&callBlankLine(mode,context.state);!stream.eol();)readToken(mode,stream,context.state),stream.start=stream.pos}function callBlankLine(mode,state){if(mode.blankLine)return mode.blankLine(state);if(mode.innerMode){var inner=innerMode(mode,state);return inner.mode.blankLine?inner.mode.blankLine(inner.state):void 0}}function readToken(mode,stream,state,inner){for(var i=0;i<10;i++){inner&&(inner[0]=innerMode(mode,state).mode);var style=mode.token(stream,state);if(stream.pos>stream.start)return style}throw new Error("Mode "+mode.name+" failed to advance stream.")}function takeToken(cm,pos,precise,asArray){var style,doc=cm.doc,mode=doc.mode;pos=clipPos(doc,pos);var tokens,line=getLine(doc,pos.line),context=getContextBefore(cm,pos.line,precise),stream=new StringStream(line.text,cm.options.tabSize,context);for(asArray&&(tokens=[]);(asArray||stream.pos<pos.ch)&&!stream.eol();)stream.start=stream.pos,style=readToken(mode,stream,context.state),asArray&&tokens.push(new Token(stream,style,copyState(doc.mode,context.state)));return asArray?tokens:new Token(stream,style,context.state)}function extractLineClasses(type,output){if(type)for(;;){var lineClass=type.match(/(?:^|\s+)line-(background-)?(\S+)/);if(!lineClass)break;type=type.slice(0,lineClass.index)+type.slice(lineClass.index+lineClass[0].length);var prop=lineClass[1]?"bgClass":"textClass";null==output[prop]?output[prop]=lineClass[2]:new RegExp("(?:^|s)"+lineClass[2]+"(?:$|s)").test(output[prop])||(output[prop]+=" "+lineClass[2])}return type}function runMode(cm,text,mode,context,f,lineClasses,forceToEnd){var flattenSpans=mode.flattenSpans;null==flattenSpans&&(flattenSpans=cm.options.flattenSpans);var style,curStart=0,curStyle=null,stream=new StringStream(text,cm.options.tabSize,context),inner=cm.options.addModeClass&&[null];for(""==text&&extractLineClasses(callBlankLine(mode,context.state),lineClasses);!stream.eol();){if(stream.pos>cm.options.maxHighlightLength?(flattenSpans=!1,forceToEnd&&processLine(cm,text,context,stream.pos),stream.pos=text.length,style=null):style=extractLineClasses(readToken(mode,stream,context.state,inner),lineClasses),inner){var mName=inner[0].name;mName&&(style="m-"+(style?mName+" "+style:mName))}if(!flattenSpans||curStyle!=style){for(;curStart<stream.start;)curStart=Math.min(stream.start,curStart+5e3),f(curStart,curStyle);curStyle=style}stream.start=stream.pos}for(;curStart<stream.pos;){var pos=Math.min(stream.pos,curStart+5e3);f(pos,curStyle),curStart=pos}}function findStartLine(cm,n,precise){for(var minindent,minline,doc=cm.doc,lim=precise?-1:n-(cm.doc.mode.innerMode?1e3:100),search=n;search>lim;--search){if(search<=doc.first)return doc.first;var line=getLine(doc,search-1),after=line.stateAfter;if(after&&(!precise||search+(after instanceof SavedContext?after.lookAhead:0)<=doc.modeFrontier))return search;var indented=countColumn(line.text,null,cm.options.tabSize);(null==minline||minindent>indented)&&(minline=search-1,minindent=indented)}return minline}function retreatFrontier(doc,n){if(doc.modeFrontier=Math.min(doc.modeFrontier,n),!(doc.highlightFrontier<n-10)){for(var start=doc.first,line=n-1;line>start;line--){var saved=getLine(doc,line).stateAfter;if(saved&&(!(saved instanceof SavedContext)||line+saved.lookAhead<n)){start=line+1;break}}doc.highlightFrontier=Math.min(doc.highlightFrontier,start)}}function seeReadOnlySpans(){sawReadOnlySpans=!0}function seeCollapsedSpans(){sawCollapsedSpans=!0}function MarkedSpan(marker,from,to){this.marker=marker,this.from=from,this.to=to}function getMarkedSpanFor(spans,marker){if(spans)for(var i=0;i<spans.length;++i){var span=spans[i];if(span.marker==marker)return span}}function removeMarkedSpan(spans,span){for(var r,i=0;i<spans.length;++i)spans[i]!=span&&(r||(r=[])).push(spans[i]);return r}function addMarkedSpan(line,span){line.markedSpans=line.markedSpans?line.markedSpans.concat([span]):[span],span.marker.attachLine(line)}function markedSpansBefore(old,startCh,isInsert){var nw;if(old)for(var i=0;i<old.length;++i){var span=old[i],marker=span.marker,startsBefore=null==span.from||(marker.inclusiveLeft?span.from<=startCh:span.from<startCh);if(startsBefore||span.from==startCh&&"bookmark"==marker.type&&(!isInsert||!span.marker.insertLeft)){var endsAfter=null==span.to||(marker.inclusiveRight?span.to>=startCh:span.to>startCh);(nw||(nw=[])).push(new MarkedSpan(marker,span.from,endsAfter?null:span.to))}}return nw}function markedSpansAfter(old,endCh,isInsert){var nw;if(old)for(var i=0;i<old.length;++i){var span=old[i],marker=span.marker,endsAfter=null==span.to||(marker.inclusiveRight?span.to>=endCh:span.to>endCh);if(endsAfter||span.from==endCh&&"bookmark"==marker.type&&(!isInsert||span.marker.insertLeft)){var startsBefore=null==span.from||(marker.inclusiveLeft?span.from<=endCh:span.from<endCh);(nw||(nw=[])).push(new MarkedSpan(marker,startsBefore?null:span.from-endCh,null==span.to?null:span.to-endCh))}}return nw}function stretchSpansOverChange(doc,change){if(change.full)return null;var oldFirst=isLine(doc,change.from.line)&&getLine(doc,change.from.line).markedSpans,oldLast=isLine(doc,change.to.line)&&getLine(doc,change.to.line).markedSpans;if(!oldFirst&&!oldLast)return null;var startCh=change.from.ch,endCh=change.to.ch,isInsert=0==cmp(change.from,change.to),first=markedSpansBefore(oldFirst,startCh,isInsert),last=markedSpansAfter(oldLast,endCh,isInsert),sameLine=1==change.text.length,offset=lst(change.text).length+(sameLine?startCh:0);if(first)for(var i=0;i<first.length;++i){var span=first[i];if(null==span.to){var found=getMarkedSpanFor(last,span.marker);found?sameLine&&(span.to=null==found.to?null:found.to+offset):span.to=startCh}}if(last)for(var i$1=0;i$1<last.length;++i$1){var span$1=last[i$1];if(null!=span$1.to&&(span$1.to+=offset),null==span$1.from){var found$1=getMarkedSpanFor(first,span$1.marker);found$1||(span$1.from=offset,sameLine&&(first||(first=[])).push(span$1))}else span$1.from+=offset,sameLine&&(first||(first=[])).push(span$1)}first&&(first=clearEmptySpans(first)),last&&last!=first&&(last=clearEmptySpans(last));var newMarkers=[first];if(!sameLine){var gapMarkers,gap=change.text.length-2;if(gap>0&&first)for(var i$2=0;i$2<first.length;++i$2)null==first[i$2].to&&(gapMarkers||(gapMarkers=[])).push(new MarkedSpan(first[i$2].marker,null,null));for(var i$3=0;i$3<gap;++i$3)newMarkers.push(gapMarkers);newMarkers.push(last)}return newMarkers}function clearEmptySpans(spans){for(var i=0;i<spans.length;++i){var span=spans[i];null!=span.from&&span.from==span.to&&span.marker.clearWhenEmpty!==!1&&spans.splice(i--,1)}return spans.length?spans:null}function removeReadOnlyRanges(doc,from,to){var markers=null;if(doc.iter(from.line,to.line+1,function(line){if(line.markedSpans)for(var i=0;i<line.markedSpans.length;++i){var mark=line.markedSpans[i].marker;!mark.readOnly||markers&&indexOf(markers,mark)!=-1||(markers||(markers=[])).push(mark)}}),!markers)return null;for(var parts=[{from:from,to:to}],i=0;i<markers.length;++i)for(var mk=markers[i],m=mk.find(0),j=0;j<parts.length;++j){var p=parts[j];if(!(cmp(p.to,m.from)<0||cmp(p.from,m.to)>0)){var newParts=[j,1],dfrom=cmp(p.from,m.from),dto=cmp(p.to,m.to);(dfrom<0||!mk.inclusiveLeft&&!dfrom)&&newParts.push({from:p.from,to:m.from}),(dto>0||!mk.inclusiveRight&&!dto)&&newParts.push({from:m.to,to:p.to}),parts.splice.apply(parts,newParts),j+=newParts.length-3}}return parts}function detachMarkedSpans(line){var spans=line.markedSpans;if(spans){for(var i=0;i<spans.length;++i)spans[i].marker.detachLine(line);line.markedSpans=null}}function attachMarkedSpans(line,spans){if(spans){for(var i=0;i<spans.length;++i)spans[i].marker.attachLine(line);line.markedSpans=spans}}function extraLeft(marker){return marker.inclusiveLeft?-1:0}function extraRight(marker){return marker.inclusiveRight?1:0}function compareCollapsedMarkers(a,b){var lenDiff=a.lines.length-b.lines.length;if(0!=lenDiff)return lenDiff;var aPos=a.find(),bPos=b.find(),fromCmp=cmp(aPos.from,bPos.from)||extraLeft(a)-extraLeft(b);if(fromCmp)return-fromCmp;var toCmp=cmp(aPos.to,bPos.to)||extraRight(a)-extraRight(b);return toCmp?toCmp:b.id-a.id}function collapsedSpanAtSide(line,start){var found,sps=sawCollapsedSpans&&line.markedSpans;if(sps)for(var sp=void 0,i=0;i<sps.length;++i)sp=sps[i],sp.marker.collapsed&&null==(start?sp.from:sp.to)&&(!found||compareCollapsedMarkers(found,sp.marker)<0)&&(found=sp.marker);return found}function collapsedSpanAtStart(line){return collapsedSpanAtSide(line,!0)}function collapsedSpanAtEnd(line){return collapsedSpanAtSide(line,!1)}function collapsedSpanAround(line,ch){var found,sps=sawCollapsedSpans&&line.markedSpans;if(sps)for(var i=0;i<sps.length;++i){var sp=sps[i];sp.marker.collapsed&&(null==sp.from||sp.from<ch)&&(null==sp.to||sp.to>ch)&&(!found||compareCollapsedMarkers(found,sp.marker)<0)&&(found=sp.marker)}return found}function conflictingCollapsedRange(doc,lineNo$$1,from,to,marker){var line=getLine(doc,lineNo$$1),sps=sawCollapsedSpans&&line.markedSpans;if(sps)for(var i=0;i<sps.length;++i){var sp=sps[i];if(sp.marker.collapsed){var found=sp.marker.find(0),fromCmp=cmp(found.from,from)||extraLeft(sp.marker)-extraLeft(marker),toCmp=cmp(found.to,to)||extraRight(sp.marker)-extraRight(marker);if(!(fromCmp>=0&&toCmp<=0||fromCmp<=0&&toCmp>=0)&&(fromCmp<=0&&(sp.marker.inclusiveRight&&marker.inclusiveLeft?cmp(found.to,from)>=0:cmp(found.to,from)>0)||fromCmp>=0&&(sp.marker.inclusiveRight&&marker.inclusiveLeft?cmp(found.from,to)<=0:cmp(found.from,to)<0)))return!0}}}function visualLine(line){for(var merged;merged=collapsedSpanAtStart(line);)line=merged.find(-1,!0).line;return line}function visualLineEnd(line){for(var merged;merged=collapsedSpanAtEnd(line);)line=merged.find(1,!0).line;return line}function visualLineContinued(line){for(var merged,lines;merged=collapsedSpanAtEnd(line);)line=merged.find(1,!0).line,(lines||(lines=[])).push(line);return lines}function visualLineNo(doc,lineN){var line=getLine(doc,lineN),vis=visualLine(line);return line==vis?lineN:lineNo(vis)}function visualLineEndNo(doc,lineN){if(lineN>doc.lastLine())return lineN;var merged,line=getLine(doc,lineN);if(!lineIsHidden(doc,line))return lineN;for(;merged=collapsedSpanAtEnd(line);)line=merged.find(1,!0).line;return lineNo(line)+1}function lineIsHidden(doc,line){var sps=sawCollapsedSpans&&line.markedSpans;if(sps)for(var sp=void 0,i=0;i<sps.length;++i)if(sp=sps[i],sp.marker.collapsed){if(null==sp.from)return!0;if(!sp.marker.widgetNode&&0==sp.from&&sp.marker.inclusiveLeft&&lineIsHiddenInner(doc,line,sp))return!0}}function lineIsHiddenInner(doc,line,span){if(null==span.to){var end=span.marker.find(1,!0);return lineIsHiddenInner(doc,end.line,getMarkedSpanFor(end.line.markedSpans,span.marker))}if(span.marker.inclusiveRight&&span.to==line.text.length)return!0;for(var sp=void 0,i=0;i<line.markedSpans.length;++i)if(sp=line.markedSpans[i],sp.marker.collapsed&&!sp.marker.widgetNode&&sp.from==span.to&&(null==sp.to||sp.to!=span.from)&&(sp.marker.inclusiveLeft||span.marker.inclusiveRight)&&lineIsHiddenInner(doc,line,sp))return!0}function heightAtLine(lineObj){lineObj=visualLine(lineObj);for(var h=0,chunk=lineObj.parent,i=0;i<chunk.lines.length;++i){var line=chunk.lines[i];if(line==lineObj)break;h+=line.height}for(var p=chunk.parent;p;chunk=p,p=chunk.parent)for(var i$1=0;i$1<p.children.length;++i$1){var cur=p.children[i$1];if(cur==chunk)break;h+=cur.height}return h}function lineLength(line){if(0==line.height)return 0;for(var merged,len=line.text.length,cur=line;merged=collapsedSpanAtStart(cur);){var found=merged.find(0,!0);cur=found.from.line,len+=found.from.ch-found.to.ch}for(cur=line;merged=collapsedSpanAtEnd(cur);){var found$1=merged.find(0,!0);len-=cur.text.length-found$1.from.ch,cur=found$1.to.line,len+=cur.text.length-found$1.to.ch}return len}function findMaxLine(cm){var d=cm.display,doc=cm.doc;d.maxLine=getLine(doc,doc.first),d.maxLineLength=lineLength(d.maxLine),d.maxLineChanged=!0,doc.iter(function(line){var len=lineLength(line);len>d.maxLineLength&&(d.maxLineLength=len,d.maxLine=line)})}function updateLine(line,text,markedSpans,estimateHeight){line.text=text,line.stateAfter&&(line.stateAfter=null),line.styles&&(line.styles=null),null!=line.order&&(line.order=null),detachMarkedSpans(line),attachMarkedSpans(line,markedSpans);var estHeight=estimateHeight?estimateHeight(line):1;estHeight!=line.height&&updateLineHeight(line,estHeight)}function cleanUpLine(line){line.parent=null,detachMarkedSpans(line)}function interpretTokenStyle(style,options){if(!style||/^\s*$/.test(style))return null;var cache=options.addModeClass?styleToClassCacheWithMode:styleToClassCache;return cache[style]||(cache[style]=style.replace(/\S+/g,"cm-$&"))}function buildLineContent(cm,lineView){var content=eltP("span",null,null,webkit?"padding-right: .1px":null),builder={pre:eltP("pre",[content],"CodeMirror-line"),content:content,col:0,pos:0,cm:cm,trailingSpace:!1,splitSpaces:cm.getOption("lineWrapping")};lineView.measure={};for(var i=0;i<=(lineView.rest?lineView.rest.length:0);i++){var line=i?lineView.rest[i-1]:lineView.line,order=void 0;builder.pos=0,builder.addToken=buildToken,hasBadBidiRects(cm.display.measure)&&(order=getOrder(line,cm.doc.direction))&&(builder.addToken=buildTokenBadBidi(builder.addToken,order)),builder.map=[];var allowFrontierUpdate=lineView!=cm.display.externalMeasured&&lineNo(line);insertLineContent(line,builder,getLineStyles(cm,line,allowFrontierUpdate)),line.styleClasses&&(line.styleClasses.bgClass&&(builder.bgClass=joinClasses(line.styleClasses.bgClass,builder.bgClass||"")),line.styleClasses.textClass&&(builder.textClass=joinClasses(line.styleClasses.textClass,builder.textClass||""))),0==builder.map.length&&builder.map.push(0,0,builder.content.appendChild(zeroWidthElement(cm.display.measure))),0==i?(lineView.measure.map=builder.map,lineView.measure.cache={}):((lineView.measure.maps||(lineView.measure.maps=[])).push(builder.map),(lineView.measure.caches||(lineView.measure.caches=[])).push({}))}if(webkit){var last=builder.content.lastChild;(/\bcm-tab\b/.test(last.className)||last.querySelector&&last.querySelector(".cm-tab"))&&(builder.content.className="cm-tab-wrap-hack")}return signal(cm,"renderLine",cm,lineView.line,builder.pre),builder.pre.className&&(builder.textClass=joinClasses(builder.pre.className,builder.textClass||"")),builder}function defaultSpecialCharPlaceholder(ch){var token=elt("span","\u2022","cm-invalidchar");return token.title="\\u"+ch.charCodeAt(0).toString(16),token.setAttribute("aria-label",token.title),token}function buildToken(builder,text,style,startStyle,endStyle,css,attributes){if(text){var content,displayText=builder.splitSpaces?splitSpaces(text,builder.trailingSpace):text,special=builder.cm.state.specialChars,mustWrap=!1;if(special.test(text)){content=document.createDocumentFragment();for(var pos=0;;){special.lastIndex=pos;var m=special.exec(text),skipped=m?m.index-pos:text.length-pos;if(skipped){var txt=document.createTextNode(displayText.slice(pos,pos+skipped));ie&&ie_version<9?content.appendChild(elt("span",[txt])):content.appendChild(txt),builder.map.push(builder.pos,builder.pos+skipped,txt),builder.col+=skipped,builder.pos+=skipped}if(!m)break;pos+=skipped+1;var txt$1=void 0;if("\t"==m[0]){var tabSize=builder.cm.options.tabSize,tabWidth=tabSize-builder.col%tabSize;txt$1=content.appendChild(elt("span",spaceStr(tabWidth),"cm-tab")),txt$1.setAttribute("role","presentation"),txt$1.setAttribute("cm-text","\t"),builder.col+=tabWidth}else"\r"==m[0]||"\n"==m[0]?(txt$1=content.appendChild(elt("span","\r"==m[0]?"\u240d":"\u2424","cm-invalidchar")),txt$1.setAttribute("cm-text",m[0]),builder.col+=1):(txt$1=builder.cm.options.specialCharPlaceholder(m[0]),txt$1.setAttribute("cm-text",m[0]),ie&&ie_version<9?content.appendChild(elt("span",[txt$1])):content.appendChild(txt$1),builder.col+=1);builder.map.push(builder.pos,builder.pos+1,txt$1),builder.pos++}}else builder.col+=text.length,content=document.createTextNode(displayText),builder.map.push(builder.pos,builder.pos+text.length,content),ie&&ie_version<9&&(mustWrap=!0),builder.pos+=text.length;if(builder.trailingSpace=32==displayText.charCodeAt(text.length-1),style||startStyle||endStyle||mustWrap||css){var fullStyle=style||"";startStyle&&(fullStyle+=startStyle),endStyle&&(fullStyle+=endStyle);var token=elt("span",[content],fullStyle,css);if(attributes)for(var attr in attributes)attributes.hasOwnProperty(attr)&&"style"!=attr&&"class"!=attr&&token.setAttribute(attr,attributes[attr]);return builder.content.appendChild(token)}builder.content.appendChild(content)}}function splitSpaces(text,trailingBefore){if(text.length>1&&!/  /.test(text))return text;for(var spaceBefore=trailingBefore,result="",i=0;i<text.length;i++){var ch=text.charAt(i);" "!=ch||!spaceBefore||i!=text.length-1&&32!=text.charCodeAt(i+1)||(ch="\xa0"),result+=ch,spaceBefore=" "==ch}return result}function buildTokenBadBidi(inner,order){return function(builder,text,style,startStyle,endStyle,css,attributes){style=style?style+" cm-force-border":"cm-force-border";for(var start=builder.pos,end=start+text.length;;){for(var part=void 0,i=0;i<order.length&&(part=order[i],!(part.to>start&&part.from<=start));i++);if(part.to>=end)return inner(builder,text,style,startStyle,endStyle,css,attributes);inner(builder,text.slice(0,part.to-start),style,startStyle,null,css,attributes),startStyle=null,text=text.slice(part.to-start),start=part.to}}}function buildCollapsedSpan(builder,size,marker,ignoreWidget){var widget=!ignoreWidget&&marker.widgetNode;widget&&builder.map.push(builder.pos,builder.pos+size,widget),!ignoreWidget&&builder.cm.display.input.needsContentAttribute&&(widget||(widget=builder.content.appendChild(document.createElement("span"))),
widget.setAttribute("cm-marker",marker.id)),widget&&(builder.cm.display.input.setUneditable(widget),builder.content.appendChild(widget)),builder.pos+=size,builder.trailingSpace=!1}function insertLineContent(line,builder,styles){var spans=line.markedSpans,allText=line.text,at=0;if(spans)for(var style,css,spanStyle,spanEndStyle,spanStartStyle,collapsed,attributes,len=allText.length,pos=0,i=1,text="",nextChange=0;;){if(nextChange==pos){spanStyle=spanEndStyle=spanStartStyle=css="",attributes=null,collapsed=null,nextChange=1/0;for(var foundBookmarks=[],endStyles=void 0,j=0;j<spans.length;++j){var sp=spans[j],m=sp.marker;if("bookmark"==m.type&&sp.from==pos&&m.widgetNode)foundBookmarks.push(m);else if(sp.from<=pos&&(null==sp.to||sp.to>pos||m.collapsed&&sp.to==pos&&sp.from==pos)){if(null!=sp.to&&sp.to!=pos&&nextChange>sp.to&&(nextChange=sp.to,spanEndStyle=""),m.className&&(spanStyle+=" "+m.className),m.css&&(css=(css?css+";":"")+m.css),m.startStyle&&sp.from==pos&&(spanStartStyle+=" "+m.startStyle),m.endStyle&&sp.to==nextChange&&(endStyles||(endStyles=[])).push(m.endStyle,sp.to),m.title&&((attributes||(attributes={})).title=m.title),m.attributes)for(var attr in m.attributes)(attributes||(attributes={}))[attr]=m.attributes[attr];m.collapsed&&(!collapsed||compareCollapsedMarkers(collapsed.marker,m)<0)&&(collapsed=sp)}else sp.from>pos&&nextChange>sp.from&&(nextChange=sp.from)}if(endStyles)for(var j$1=0;j$1<endStyles.length;j$1+=2)endStyles[j$1+1]==nextChange&&(spanEndStyle+=" "+endStyles[j$1]);if(!collapsed||collapsed.from==pos)for(var j$2=0;j$2<foundBookmarks.length;++j$2)buildCollapsedSpan(builder,0,foundBookmarks[j$2]);if(collapsed&&(collapsed.from||0)==pos){if(buildCollapsedSpan(builder,(null==collapsed.to?len+1:collapsed.to)-pos,collapsed.marker,null==collapsed.from),null==collapsed.to)return;collapsed.to==pos&&(collapsed=!1)}}if(pos>=len)break;for(var upto=Math.min(len,nextChange);;){if(text){var end=pos+text.length;if(!collapsed){var tokenText=end>upto?text.slice(0,upto-pos):text;builder.addToken(builder,tokenText,style?style+spanStyle:spanStyle,spanStartStyle,pos+tokenText.length==nextChange?spanEndStyle:"",css,attributes)}if(end>=upto){text=text.slice(upto-pos),pos=upto;break}pos=end,spanStartStyle=""}text=allText.slice(at,at=styles[i++]),style=interpretTokenStyle(styles[i++],builder.cm.options)}}else for(var i$1=1;i$1<styles.length;i$1+=2)builder.addToken(builder,allText.slice(at,at=styles[i$1]),interpretTokenStyle(styles[i$1+1],builder.cm.options))}function LineView(doc,line,lineN){this.line=line,this.rest=visualLineContinued(line),this.size=this.rest?lineNo(lst(this.rest))-lineN+1:1,this.node=this.text=null,this.hidden=lineIsHidden(doc,line)}function buildViewArray(cm,from,to){for(var nextPos,array=[],pos=from;pos<to;pos=nextPos){var view=new LineView(cm.doc,getLine(cm.doc,pos),pos);nextPos=pos+view.size,array.push(view)}return array}function pushOperation(op){operationGroup?operationGroup.ops.push(op):op.ownsGroup=operationGroup={ops:[op],delayedCallbacks:[]}}function fireCallbacksForOps(group){var callbacks=group.delayedCallbacks,i=0;do{for(;i<callbacks.length;i++)callbacks[i].call(null);for(var j=0;j<group.ops.length;j++){var op=group.ops[j];if(op.cursorActivityHandlers)for(;op.cursorActivityCalled<op.cursorActivityHandlers.length;)op.cursorActivityHandlers[op.cursorActivityCalled++].call(null,op.cm)}}while(i<callbacks.length)}function finishOperation(op,endCb){var group=op.ownsGroup;if(group)try{fireCallbacksForOps(group)}finally{operationGroup=null,endCb(group)}}function signalLater(emitter,type){var arr=getHandlers(emitter,type);if(arr.length){var list,args=Array.prototype.slice.call(arguments,2);operationGroup?list=operationGroup.delayedCallbacks:orphanDelayedCallbacks?list=orphanDelayedCallbacks:(list=orphanDelayedCallbacks=[],setTimeout(fireOrphanDelayed,0));for(var loop=function(i){list.push(function(){return arr[i].apply(null,args)})},i=0;i<arr.length;++i)loop(i)}}function fireOrphanDelayed(){var delayed=orphanDelayedCallbacks;orphanDelayedCallbacks=null;for(var i=0;i<delayed.length;++i)delayed[i]()}function updateLineForChanges(cm,lineView,lineN,dims){for(var j=0;j<lineView.changes.length;j++){var type=lineView.changes[j];"text"==type?updateLineText(cm,lineView):"gutter"==type?updateLineGutter(cm,lineView,lineN,dims):"class"==type?updateLineClasses(cm,lineView):"widget"==type&&updateLineWidgets(cm,lineView,dims)}lineView.changes=null}function ensureLineWrapped(lineView){return lineView.node==lineView.text&&(lineView.node=elt("div",null,null,"position: relative"),lineView.text.parentNode&&lineView.text.parentNode.replaceChild(lineView.node,lineView.text),lineView.node.appendChild(lineView.text),ie&&ie_version<8&&(lineView.node.style.zIndex=2)),lineView.node}function updateLineBackground(cm,lineView){var cls=lineView.bgClass?lineView.bgClass+" "+(lineView.line.bgClass||""):lineView.line.bgClass;if(cls&&(cls+=" CodeMirror-linebackground"),lineView.background)cls?lineView.background.className=cls:(lineView.background.parentNode.removeChild(lineView.background),lineView.background=null);else if(cls){var wrap=ensureLineWrapped(lineView);lineView.background=wrap.insertBefore(elt("div",null,cls),wrap.firstChild),cm.display.input.setUneditable(lineView.background)}}function getLineContent(cm,lineView){var ext=cm.display.externalMeasured;return ext&&ext.line==lineView.line?(cm.display.externalMeasured=null,lineView.measure=ext.measure,ext.built):buildLineContent(cm,lineView)}function updateLineText(cm,lineView){var cls=lineView.text.className,built=getLineContent(cm,lineView);lineView.text==lineView.node&&(lineView.node=built.pre),lineView.text.parentNode.replaceChild(built.pre,lineView.text),lineView.text=built.pre,built.bgClass!=lineView.bgClass||built.textClass!=lineView.textClass?(lineView.bgClass=built.bgClass,lineView.textClass=built.textClass,updateLineClasses(cm,lineView)):cls&&(lineView.text.className=cls)}function updateLineClasses(cm,lineView){updateLineBackground(cm,lineView),lineView.line.wrapClass?ensureLineWrapped(lineView).className=lineView.line.wrapClass:lineView.node!=lineView.text&&(lineView.node.className="");var textClass=lineView.textClass?lineView.textClass+" "+(lineView.line.textClass||""):lineView.line.textClass;lineView.text.className=textClass||""}function updateLineGutter(cm,lineView,lineN,dims){if(lineView.gutter&&(lineView.node.removeChild(lineView.gutter),lineView.gutter=null),lineView.gutterBackground&&(lineView.node.removeChild(lineView.gutterBackground),lineView.gutterBackground=null),lineView.line.gutterClass){var wrap=ensureLineWrapped(lineView);lineView.gutterBackground=elt("div",null,"CodeMirror-gutter-background "+lineView.line.gutterClass,"left: "+(cm.options.fixedGutter?dims.fixedPos:-dims.gutterTotalWidth)+"px; width: "+dims.gutterTotalWidth+"px"),cm.display.input.setUneditable(lineView.gutterBackground),wrap.insertBefore(lineView.gutterBackground,lineView.text)}var markers=lineView.line.gutterMarkers;if(cm.options.lineNumbers||markers){var wrap$1=ensureLineWrapped(lineView),gutterWrap=lineView.gutter=elt("div",null,"CodeMirror-gutter-wrapper","left: "+(cm.options.fixedGutter?dims.fixedPos:-dims.gutterTotalWidth)+"px");if(cm.display.input.setUneditable(gutterWrap),wrap$1.insertBefore(gutterWrap,lineView.text),lineView.line.gutterClass&&(gutterWrap.className+=" "+lineView.line.gutterClass),!cm.options.lineNumbers||markers&&markers["CodeMirror-linenumbers"]||(lineView.lineNumber=gutterWrap.appendChild(elt("div",lineNumberFor(cm.options,lineN),"CodeMirror-linenumber CodeMirror-gutter-elt","left: "+dims.gutterLeft["CodeMirror-linenumbers"]+"px; width: "+cm.display.lineNumInnerWidth+"px"))),markers)for(var k=0;k<cm.display.gutterSpecs.length;++k){var id=cm.display.gutterSpecs[k].className,found=markers.hasOwnProperty(id)&&markers[id];found&&gutterWrap.appendChild(elt("div",[found],"CodeMirror-gutter-elt","left: "+dims.gutterLeft[id]+"px; width: "+dims.gutterWidth[id]+"px"))}}}function updateLineWidgets(cm,lineView,dims){lineView.alignable&&(lineView.alignable=null);for(var isWidget=classTest("CodeMirror-linewidget"),node=lineView.node.firstChild,next=void 0;node;node=next)next=node.nextSibling,isWidget.test(node.className)&&lineView.node.removeChild(node);insertLineWidgets(cm,lineView,dims)}function buildLineElement(cm,lineView,lineN,dims){var built=getLineContent(cm,lineView);return lineView.text=lineView.node=built.pre,built.bgClass&&(lineView.bgClass=built.bgClass),built.textClass&&(lineView.textClass=built.textClass),updateLineClasses(cm,lineView),updateLineGutter(cm,lineView,lineN,dims),insertLineWidgets(cm,lineView,dims),lineView.node}function insertLineWidgets(cm,lineView,dims){if(insertLineWidgetsFor(cm,lineView.line,lineView,dims,!0),lineView.rest)for(var i=0;i<lineView.rest.length;i++)insertLineWidgetsFor(cm,lineView.rest[i],lineView,dims,!1)}function insertLineWidgetsFor(cm,line,lineView,dims,allowAbove){if(line.widgets)for(var wrap=ensureLineWrapped(lineView),i=0,ws=line.widgets;i<ws.length;++i){var widget=ws[i],node=elt("div",[widget.node],"CodeMirror-linewidget"+(widget.className?" "+widget.className:""));widget.handleMouseEvents||node.setAttribute("cm-ignore-events","true"),positionLineWidget(widget,node,lineView,dims),cm.display.input.setUneditable(node),allowAbove&&widget.above?wrap.insertBefore(node,lineView.gutter||lineView.text):wrap.appendChild(node),signalLater(widget,"redraw")}}function positionLineWidget(widget,node,lineView,dims){if(widget.noHScroll){(lineView.alignable||(lineView.alignable=[])).push(node);var width=dims.wrapperWidth;node.style.left=dims.fixedPos+"px",widget.coverGutter||(width-=dims.gutterTotalWidth,node.style.paddingLeft=dims.gutterTotalWidth+"px"),node.style.width=width+"px"}widget.coverGutter&&(node.style.zIndex=5,node.style.position="relative",widget.noHScroll||(node.style.marginLeft=-dims.gutterTotalWidth+"px"))}function widgetHeight(widget){if(null!=widget.height)return widget.height;var cm=widget.doc.cm;if(!cm)return 0;if(!contains(document.body,widget.node)){var parentStyle="position: relative;";widget.coverGutter&&(parentStyle+="margin-left: -"+cm.display.gutters.offsetWidth+"px;"),widget.noHScroll&&(parentStyle+="width: "+cm.display.wrapper.clientWidth+"px;"),removeChildrenAndAdd(cm.display.measure,elt("div",[widget.node],null,parentStyle))}return widget.height=widget.node.parentNode.offsetHeight}function eventInWidget(display,e){for(var n=e_target(e);n!=display.wrapper;n=n.parentNode)if(!n||1==n.nodeType&&"true"==n.getAttribute("cm-ignore-events")||n.parentNode==display.sizer&&n!=display.mover)return!0}function paddingTop(display){return display.lineSpace.offsetTop}function paddingVert(display){return display.mover.offsetHeight-display.lineSpace.offsetHeight}function paddingH(display){if(display.cachedPaddingH)return display.cachedPaddingH;var e=removeChildrenAndAdd(display.measure,elt("pre","x","CodeMirror-line-like")),style=window.getComputedStyle?window.getComputedStyle(e):e.currentStyle,data={left:parseInt(style.paddingLeft),right:parseInt(style.paddingRight)};return isNaN(data.left)||isNaN(data.right)||(display.cachedPaddingH=data),data}function scrollGap(cm){return scrollerGap-cm.display.nativeBarWidth}function displayWidth(cm){return cm.display.scroller.clientWidth-scrollGap(cm)-cm.display.barWidth}function displayHeight(cm){return cm.display.scroller.clientHeight-scrollGap(cm)-cm.display.barHeight}function ensureLineHeights(cm,lineView,rect){var wrapping=cm.options.lineWrapping,curWidth=wrapping&&displayWidth(cm);if(!lineView.measure.heights||wrapping&&lineView.measure.width!=curWidth){var heights=lineView.measure.heights=[];if(wrapping){lineView.measure.width=curWidth;for(var rects=lineView.text.firstChild.getClientRects(),i=0;i<rects.length-1;i++){var cur=rects[i],next=rects[i+1];Math.abs(cur.bottom-next.bottom)>2&&heights.push((cur.bottom+next.top)/2-rect.top)}}heights.push(rect.bottom-rect.top)}}function mapFromLineView(lineView,line,lineN){if(lineView.line==line)return{map:lineView.measure.map,cache:lineView.measure.cache};for(var i=0;i<lineView.rest.length;i++)if(lineView.rest[i]==line)return{map:lineView.measure.maps[i],cache:lineView.measure.caches[i]};for(var i$1=0;i$1<lineView.rest.length;i$1++)if(lineNo(lineView.rest[i$1])>lineN)return{map:lineView.measure.maps[i$1],cache:lineView.measure.caches[i$1],before:!0}}function updateExternalMeasurement(cm,line){line=visualLine(line);var lineN=lineNo(line),view=cm.display.externalMeasured=new LineView(cm.doc,line,lineN);view.lineN=lineN;var built=view.built=buildLineContent(cm,view);return view.text=built.pre,removeChildrenAndAdd(cm.display.lineMeasure,built.pre),view}function measureChar(cm,line,ch,bias){return measureCharPrepared(cm,prepareMeasureForLine(cm,line),ch,bias)}function findViewForLine(cm,lineN){if(lineN>=cm.display.viewFrom&&lineN<cm.display.viewTo)return cm.display.view[findViewIndex(cm,lineN)];var ext=cm.display.externalMeasured;return ext&&lineN>=ext.lineN&&lineN<ext.lineN+ext.size?ext:void 0}function prepareMeasureForLine(cm,line){var lineN=lineNo(line),view=findViewForLine(cm,lineN);view&&!view.text?view=null:view&&view.changes&&(updateLineForChanges(cm,view,lineN,getDimensions(cm)),cm.curOp.forceUpdate=!0),view||(view=updateExternalMeasurement(cm,line));var info=mapFromLineView(view,line,lineN);return{line:line,view:view,rect:null,map:info.map,cache:info.cache,before:info.before,hasHeights:!1}}function measureCharPrepared(cm,prepared,ch,bias,varHeight){prepared.before&&(ch=-1);var found,key=ch+(bias||"");return prepared.cache.hasOwnProperty(key)?found=prepared.cache[key]:(prepared.rect||(prepared.rect=prepared.view.text.getBoundingClientRect()),prepared.hasHeights||(ensureLineHeights(cm,prepared.view,prepared.rect),prepared.hasHeights=!0),found=measureCharInner(cm,prepared,ch,bias),found.bogus||(prepared.cache[key]=found)),{left:found.left,right:found.right,top:varHeight?found.rtop:found.top,bottom:varHeight?found.rbottom:found.bottom}}function nodeAndOffsetInLineMap(map$$1,ch,bias){for(var node,start,end,collapse,mStart,mEnd,i=0;i<map$$1.length;i+=3)if(mStart=map$$1[i],mEnd=map$$1[i+1],ch<mStart?(start=0,end=1,collapse="left"):ch<mEnd?(start=ch-mStart,end=start+1):(i==map$$1.length-3||ch==mEnd&&map$$1[i+3]>ch)&&(end=mEnd-mStart,start=end-1,ch>=mEnd&&(collapse="right")),null!=start){if(node=map$$1[i+2],mStart==mEnd&&bias==(node.insertLeft?"left":"right")&&(collapse=bias),"left"==bias&&0==start)for(;i&&map$$1[i-2]==map$$1[i-3]&&map$$1[i-1].insertLeft;)node=map$$1[(i-=3)+2],collapse="left";if("right"==bias&&start==mEnd-mStart)for(;i<map$$1.length-3&&map$$1[i+3]==map$$1[i+4]&&!map$$1[i+5].insertLeft;)node=map$$1[(i+=3)+2],collapse="right";break}return{node:node,start:start,end:end,collapse:collapse,coverStart:mStart,coverEnd:mEnd}}function getUsefulRect(rects,bias){var rect=nullRect;if("left"==bias)for(var i=0;i<rects.length&&(rect=rects[i]).left==rect.right;i++);else for(var i$1=rects.length-1;i$1>=0&&(rect=rects[i$1]).left==rect.right;i$1--);return rect}function measureCharInner(cm,prepared,ch,bias){var rect,place=nodeAndOffsetInLineMap(prepared.map,ch,bias),node=place.node,start=place.start,end=place.end,collapse=place.collapse;if(3==node.nodeType){for(var i$1=0;i$1<4;i$1++){for(;start&&isExtendingChar(prepared.line.text.charAt(place.coverStart+start));)--start;for(;place.coverStart+end<place.coverEnd&&isExtendingChar(prepared.line.text.charAt(place.coverStart+end));)++end;if(rect=ie&&ie_version<9&&0==start&&end==place.coverEnd-place.coverStart?node.parentNode.getBoundingClientRect():getUsefulRect(range(node,start,end).getClientRects(),bias),rect.left||rect.right||0==start)break;end=start,start-=1,collapse="right"}ie&&ie_version<11&&(rect=maybeUpdateRectForZooming(cm.display.measure,rect))}else{start>0&&(collapse=bias="right");var rects;rect=cm.options.lineWrapping&&(rects=node.getClientRects()).length>1?rects["right"==bias?rects.length-1:0]:node.getBoundingClientRect()}if(ie&&ie_version<9&&!start&&(!rect||!rect.left&&!rect.right)){var rSpan=node.parentNode.getClientRects()[0];rect=rSpan?{left:rSpan.left,right:rSpan.left+charWidth(cm.display),top:rSpan.top,bottom:rSpan.bottom}:nullRect}for(var rtop=rect.top-prepared.rect.top,rbot=rect.bottom-prepared.rect.top,mid=(rtop+rbot)/2,heights=prepared.view.measure.heights,i=0;i<heights.length-1&&!(mid<heights[i]);i++);var top=i?heights[i-1]:0,bot=heights[i],result={left:("right"==collapse?rect.right:rect.left)-prepared.rect.left,right:("left"==collapse?rect.left:rect.right)-prepared.rect.left,top:top,bottom:bot};return rect.left||rect.right||(result.bogus=!0),cm.options.singleCursorHeightPerLine||(result.rtop=rtop,result.rbottom=rbot),result}function maybeUpdateRectForZooming(measure,rect){if(!window.screen||null==screen.logicalXDPI||screen.logicalXDPI==screen.deviceXDPI||!hasBadZoomedRects(measure))return rect;var scaleX=screen.logicalXDPI/screen.deviceXDPI,scaleY=screen.logicalYDPI/screen.deviceYDPI;return{left:rect.left*scaleX,right:rect.right*scaleX,top:rect.top*scaleY,bottom:rect.bottom*scaleY}}function clearLineMeasurementCacheFor(lineView){if(lineView.measure&&(lineView.measure.cache={},lineView.measure.heights=null,lineView.rest))for(var i=0;i<lineView.rest.length;i++)lineView.measure.caches[i]={}}function clearLineMeasurementCache(cm){cm.display.externalMeasure=null,removeChildren(cm.display.lineMeasure);for(var i=0;i<cm.display.view.length;i++)clearLineMeasurementCacheFor(cm.display.view[i])}function clearCaches(cm){clearLineMeasurementCache(cm),cm.display.cachedCharWidth=cm.display.cachedTextHeight=cm.display.cachedPaddingH=null,cm.options.lineWrapping||(cm.display.maxLineChanged=!0),cm.display.lineNumChars=null}function pageScrollX(){return chrome&&android?-(document.body.getBoundingClientRect().left-parseInt(getComputedStyle(document.body).marginLeft)):window.pageXOffset||(document.documentElement||document.body).scrollLeft}function pageScrollY(){return chrome&&android?-(document.body.getBoundingClientRect().top-parseInt(getComputedStyle(document.body).marginTop)):window.pageYOffset||(document.documentElement||document.body).scrollTop}function widgetTopHeight(lineObj){var height=0;if(lineObj.widgets)for(var i=0;i<lineObj.widgets.length;++i)lineObj.widgets[i].above&&(height+=widgetHeight(lineObj.widgets[i]));return height}function intoCoordSystem(cm,lineObj,rect,context,includeWidgets){if(!includeWidgets){var height=widgetTopHeight(lineObj);rect.top+=height,rect.bottom+=height}if("line"==context)return rect;context||(context="local");var yOff=heightAtLine(lineObj);if("local"==context?yOff+=paddingTop(cm.display):yOff-=cm.display.viewOffset,"page"==context||"window"==context){var lOff=cm.display.lineSpace.getBoundingClientRect();yOff+=lOff.top+("window"==context?0:pageScrollY());var xOff=lOff.left+("window"==context?0:pageScrollX());rect.left+=xOff,rect.right+=xOff}return rect.top+=yOff,rect.bottom+=yOff,rect}function fromCoordSystem(cm,coords,context){if("div"==context)return coords;var left=coords.left,top=coords.top;if("page"==context)left-=pageScrollX(),top-=pageScrollY();else if("local"==context||!context){var localBox=cm.display.sizer.getBoundingClientRect();left+=localBox.left,top+=localBox.top}var lineSpaceBox=cm.display.lineSpace.getBoundingClientRect();return{left:left-lineSpaceBox.left,top:top-lineSpaceBox.top}}function charCoords(cm,pos,context,lineObj,bias){return lineObj||(lineObj=getLine(cm.doc,pos.line)),intoCoordSystem(cm,lineObj,measureChar(cm,lineObj,pos.ch,bias),context)}function cursorCoords(cm,pos,context,lineObj,preparedMeasure,varHeight){function get(ch,right){var m=measureCharPrepared(cm,preparedMeasure,ch,right?"right":"left",varHeight);return right?m.left=m.right:m.right=m.left,intoCoordSystem(cm,lineObj,m,context)}function getBidi(ch,partPos,invert){var part=order[partPos],right=1==part.level;return get(invert?ch-1:ch,right!=invert)}lineObj=lineObj||getLine(cm.doc,pos.line),preparedMeasure||(preparedMeasure=prepareMeasureForLine(cm,lineObj));var order=getOrder(lineObj,cm.doc.direction),ch=pos.ch,sticky=pos.sticky;if(ch>=lineObj.text.length?(ch=lineObj.text.length,sticky="before"):ch<=0&&(ch=0,sticky="after"),!order)return get("before"==sticky?ch-1:ch,"before"==sticky);var partPos=getBidiPartAt(order,ch,sticky),other=bidiOther,val=getBidi(ch,partPos,"before"==sticky);return null!=other&&(val.other=getBidi(ch,other,"before"!=sticky)),val}function estimateCoords(cm,pos){var left=0;pos=clipPos(cm.doc,pos),cm.options.lineWrapping||(left=charWidth(cm.display)*pos.ch);var lineObj=getLine(cm.doc,pos.line),top=heightAtLine(lineObj)+paddingTop(cm.display);return{left: